import React, { useEffect, useState } from 'react'
import styles from './style.module.scss'
import NewsCard from '@/fragments/news_card'
import api from '../../services/api'

const FeaturingNews = () => {
  const [featuringNews, setFeaturingNews] = useState<any[] | undefined>()
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    
    const getFeaturingNews = async () => {
      setLoading(true);
      try {
        const res = await api.get(`/noticias?filters[destaque][$eq]=true&populate=*`)
        const {data, status } = res
        if (status !== 200) throw new Error()
        setFeaturingNews(data.data)
      } catch (error) {
        console.log(error)
      } finally {
        setLoading(false);
      }
    }
     if (!featuringNews) {
      getFeaturingNews()
    }
  }, [featuringNews])
  //if (!featuringNews && !loading) return null
  return (
    <section className={styles.news_container}>
      {loading && <div className={styles.loader_container}><div className={styles.loader}></div></div> }
      {featuringNews?.slice(0, 3).map((item) => (
        <NewsCard key={item.id} item={{ ...item.attributes, id: item.id }} />
      ))}
    </section>
  );
}

export default FeaturingNews
