import React, { useState } from 'react'
import styles from './style.module.scss'
import { useRouter } from 'next/router'

const MobileNavigation = ({navigation_items}: any) => {
    const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false)
    const router = useRouter()

    function handleClick (item?: any) {
      setIsMobileMenuOpen(false)
      !!item && item.onClick()
    }

  return (
    <>
    <div style={{padding: '0px'}} onClick={() => setIsMobileMenuOpen(true)}>
      <svg width="24" height="24" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
        <line x1="1" y1="1" x2="15" y2="1" stroke="white" strokeWidth="2" strokeLinecap="round"/>
        <line x1="5" y1="7" x2="15" y2="7" stroke="white" strokeWidth="2" strokeLinecap="round"/>
        <line x1="1" y1="13" x2="15" y2="13" stroke="white" strokeWidth="2" strokeLinecap="round"/>
      </svg>
    </div>
    {isMobileMenuOpen && <div className={styles.modal_menu_wrapper}>
      <div className={styles.mobile_menu_content}>
        <div className={styles.mobile_menu_close} >
          <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" onClick={() => setIsMobileMenuOpen(false)}>
          <path d="M1.00003 1L17 17" stroke="#622167" strokeWidth="2" strokeLinecap="round"/>
          <path d="M17 1L1.00003 17" stroke="#622167" strokeWidth="2" strokeLinecap="round"/>
          </svg>
        </div>
        <nav>
          <ul className={styles.mobile_nav}>
          <li onClick={() => handleClick({onClick: () => router.push('/')})}>
                <div><svg width="20" height="17" viewBox="0 0 20 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 2.69L15 7.19V15H13V9H7V15H5V7.19L10 2.69ZM10 0L0 9H3V17H9V11H11V17H17V9H20L10 0Z" fill="#622167"/>
</svg>
</div>
                <div>Início</div>
              </li>
            {navigation_items.map((item: any) => (
              <li key={item.name} onClick={() => handleClick(item)}>
                <div style={{width: '16px'}}>{item?.icon}</div>
                <div>{item.name}</div>
              </li>
            ))}
          </ul>
        </nav>
      </div>
    </div>}
    </>
  )
}

export default MobileNavigation