import Image, { StaticImageData } from "next/image"
import style from "./style.module.scss"
import bannerImg from "./../../assets/needHelp/agentIABannerNeedHelp.png"
import logoImg from "./../../assets/needHelp/logoRoxa.png"
import linkImg from "./../../assets/needHelp/urlLink.png"
import chatImg from "./../../assets/needHelp/ChatCircleDots.png"
import bagImg from "./../../assets/needHelp/bag.png"
import busImg from "./../../assets/needHelp/bus.png"
import identifyImg from "./../../assets/needHelp/IdentificationCard.png"
import chairImg from "./../../assets/needHelp/Wheelchair.png"

type Card = {
        logo: string,
        title: string,
        text: string,
        link: string,
        textColor?: "default" | "green"
    }


const NeedHelp = () => {
    
    const appLink = 'https://play.google.com/store/apps/details?id=br.bus2.moovitaqua&hl=pt_BR'
    const chatLink = 'https://wa.me/5511933152362'
    const vtLink = ''
    const avulsoLink = ''
    const escolarLink = ''
    const gratuitoLink = ''

    const navigateToOutsidePage = ( external_url: string ) => window.open(external_url, '_blank')

    const blueTextCards = ["Avulso", "Escolar"]

    const cards: Card[] = [
        {
            logo: logoImg.src,
            title: "APP",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: appLink,
        },
        {
            logo: chatImg.src,
            title: "Chat",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: chatLink,
        },
        {
            logo: busImg.src,
            title: "Vale Transporte",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: vtLink,
        },
        {
            logo: identifyImg.src,
            title: "Avulso",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: avulsoLink,
            textColor: "green"
        },
        {
            logo: bagImg.src,
            title: "Escolar",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: escolarLink,
            textColor: "green"
        },
        {
            logo: chairImg.src,
            title: "Gratuidade",
            text: "Lorem ipsum dolor sit amet consectetur. Iaculis iaculis facilisis elementum pharetra dictumst. Duis condimentum vestibulum bibendum scelerisque vitae mauris sed ultrices. Nisl sagittis ante urna euismod",
            link: gratuitoLink,
        },
    ]

    
    
    return (
        <>
        <section className={style.section}>
            <div className={style.container}>
                <div className={style.banner}>
                <div className={style.textContent}>
                    <h1>Precisa de ajuda?</h1>
                    <p>Se você precisa de ajuda com algum de nossos produtos entre no link abaixo e tire suas dúvidas.</p>
                    <div className={style.ctaButton}>
                        <button className={style.buttonAccess} onClick={ ()=> navigateToOutsidePage(chatLink) }>Acesse aqui</button>
                    </div>
                </div>
                <Image className={style.img} src={bannerImg} alt="Atendente" />
            </div>
            {/* <div className={style.links}>   
                {cards.map((card, index) => (
                    <div key={index} className={style.card}>
                        <div className={style.cardHeader}>
                          <Image src={card.logo} alt={card.title} width={40} height={40} />
                        </div>
                        <h3 className={style.cardTitle}>{card.title}</h3>
                        <p className={`${style.cardText} ${card.textColor == "green" ? style.blueText : ""}`}>
                              {card.text}
                        </p>
                        <a href={card.link} target="_blank" className={style.cardButton}>
                              <Image src={linkImg} alt="Link"/>
                        </a>
                    </div>
                ))}
            </div> */}
            </div>
        </section>
        </>
    )
}

export default NeedHelp