import React from "react";
import styles from "./style.module.scss";
import Image from "next/image";
import whatsappChatImg from "../../assets/secondSection/whatsappChat.png"
import logo2 from "../../assets/secondSection/Moov-Itaqua-logo-2.png"
import whatsapp from "../../assets/whatsapp.png"
import recargaPay from "../../assets/recargaPayIcon.png"
import googleStore from "../../assets/secondSection/GooglePlay.png"
import appStore from "../../assets/secondSection/AppStore.png"

const SecondSection = () => {
  const urlGoogleStore:string =  "https://play.google.com/store/apps/details?id=br.bus2.moovitaqua&hl=pt_BR"
  const urlAppStore:string = "https://apps.apple.com/br/app/moov-itaqu%C3%A1/id6483494881"
  const whatsappLink:string = "https://wa.me/5511933152362"
  const recargaPayLink:string = "https://play.google.com/store/apps/details?id=com.recarga.recarga&hl=pt_BR"

  return (
    <section className={styles.section_container}>
      <div className={styles.container}>
        <div className={styles.firstImg}>
          <Image src={whatsappChatImg} alt="Whatsapp Chat" className={styles.imagens}/>
        </div>
        <div className={styles.textContainer}>
          <div className={styles.title}>
            <h2>Escolha como recarregar</h2>
            <a href={whatsappLink} target="_blank" className={styles.chatbot}>
              <Image src={whatsapp} alt="Whatsapp" />
              Via Whatsapp
            </a>
            <a href={recargaPayLink} target="_blank" className={styles.recargaPay}>
              <Image src={recargaPay} alt="recarga Pay" />
            </a>
          </div>
            <div className={styles.textContent}>
              <Image src={logo2} alt="Moovi Itaquá" />
              <p>Caso queria você também pode baixar o </p>
              <p>App da Moov e fazer a recarga do seu </p>
              <p>vale.</p>
            </div>
            <div className={styles.Stores}>
              <a href={urlGoogleStore} target="_blank">
                <Image src={googleStore} alt="Google Play" />
              </a>
              <a href={urlAppStore} target="_blank">
                <Image src={appStore} alt="Apple Store" />
              </a>
            </div>
      </div>
      </div>
    </section>
  );
};

export default SecondSection;
