import styles from "./styles.module.scss";

type CardItem = string | {
  type: string;
};

type Card = {
  id: number;
  title: string;
  items: CardItem[];
  button: string;
  link:string
};

const ThirdSection = () => {

  const whatsappLink:string = 'https://wa.me/5511933152362'

  const cards: Card[] = [
    {
      id: 1,
      title: "Comum",
      items: [
        "Uso pessoal",
        "Recargas avulsas",
        "Solicitar a primeira via direto na agencia",
        "Documentos para solicitação: RG e CPF",
        "Primeira via por R$7,10",
        "Primeira recarga R$6,00",
      ],
      button: "Solicitar",
      link: whatsappLink
    },
    {
        id: 2,
        title: "Vale Transporte",
        items: [
          "Para trabalhadores",
          "Trajeto casa ↔ trabalho",
          "Recarga feita pela empresa",
          {
            type: "contact"
          }
        ],
        button: "Solicitar",
        link: whatsappLink
    },
    {
      id: 3,
      title: "Escolar",
      items: [
        "Estudantes da rede pública",
        "Estudantes da rede privada",
        "Meia-tarifa",
      ],
      button: "Saiba mais",
      link: "#escolar"
    },
    {
      id: 4,
      title: "Gratuidade",
      items: [
        "Pessoal e intransferível",
        "Para usuários com isenção tarifária",
        "Idosos",
        "Documentos: RG, CPF, comprovante de endereço",
        // "Atendimento: CEMI Centro de Convivência da Melhor Idade",
        "PCD",
        "Documentos: Cartão destinado a pessoas com necessidades especiais",
        // "Atendimento: Rua Carlos Barbosa da Silva, 51 - Centro, Itaquaquecetuba - SP"
      ],
      button: "Saiba mais",
      link: whatsappLink
    },
  ];

  return (
    <section className={styles.section} id="thirdSession">
      <div className={styles.container}>
        <div className={styles.title}>
          <h1>Escolha o cartão ideal para você</h1>
        </div>
        <div className={styles.cards}>
          {cards.map((card) => (
            <div key={card.id} className={styles.card}>
              <div className={styles.cardHeader}>
                {card.title}
              </div>

              <ul className={styles.cardBody}>
              {card.items.map((item, index) => {
                  if (typeof item === "string") {
                  return <li key={index}>{item}</li>;
                  }

                  if (item.type === "contact") {
                      return (
                          <li key={index} className={styles.contact}>
                          <span>Para solicitar entrar em contato:</span>
                          <strong>empresas@moovitaqua.com.br</strong>
                          <a href={whatsappLink} target="_blank">
                              <strong>(11) 97217-1926</strong>
                          </a>
                          </li>
                      );
                  }
                      return null;
                  })}
              </ul>

              <a href={card.link} target={card.link.startsWith("#") ? "_self" : "_blank"} className={styles.button}>
                  {card.button}
              </a>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default ThirdSection;
