'use client';

type StyledSizeProps =
  | 'extra-small'
  | 'small'
  | 'default'
  | 'normal'
  | 'medium'
  | 'large';

type Props = {
  size: StyledSizeProps;
};

const paddings = {
    'extra-small': 5,
    small: 10,
    default: 20,
    normal: 25,
    medium: 40,
    large: 55,
};

export default function BoxInvisible({ size = 'default' }: Props) {
  return <div style={{ padding: paddings[size] }}></div>;
}