import { useState, ReactNode } from 'react'
import styles from './style.module.scss'

interface FaqItemProps {
  item?: {
    question: string
    answer?: string
  }
  children?: ReactNode
}

const FaqItem = ({ item, children }: FaqItemProps) => {
  const [isOpen, setIsOpen] = useState(false)
  return (
    <div className={`${styles.faq_item_container} ${isOpen ? styles.open : ''}`} onClick={() => setIsOpen(prevState => !prevState)}>
      <div className={styles.faq_item_answer}>
        <div className={`${styles.icon} ${isOpen ? styles.icon_open : ''}`}>
          <svg width="24" height="28" viewBox="0 0 16 16" fill="currentColor">
            <path fillRule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
          </svg>
        </div>
        <h2>{item?.question}</h2>
      </div>
      <div className={`${styles.faq_answer_wrapper} ${isOpen ? styles.wrapper_open : ''}`}>
        <div className={styles.faq_answer}>
          {item?.answer && <p>{item.answer}</p>}
          {children}
        </div>
      </div>
    </div>
  )
}

export default FaqItem