import React from 'react'
import PageButton from './pageButton';

type Props = {
  pagination: {
    page: number;
    pageCount?: number;
    pageSize?: number;
    total: number;
  },
  handleChangePage: (page: number) => void;
}
const Pagination = ({pagination, handleChangePage}: Props) => {
  const {page, total, pageCount} = pagination
  const limitPerPage = 9
  const siblingsCount = 1

  function generatePagesArray (from: number, to: number) {
    return (
        [...new Array(to - from)]
        .map((_, index) => (
            from + index + 1
        ))
        .filter(page => page > 0)
    )
}
const previousPages = page > 1
? generatePagesArray(page - 1 - siblingsCount, page - 1)
: []

const nextPages = page < (pageCount || 0)
? generatePagesArray(page, Math.min(page + siblingsCount, (pageCount || 0)))
: []

if (!page) return null
  return (
      <>
              {!(page === 1) && 
              <div onClick={() => handleChangePage(page - 1)} style={{cursor: 'pointer'}}>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" className="bi bi-chevron-left" viewBox="0 0 16 16">
  <path fillRule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0z"/>
</svg>
                </div>}
              {page > (1 + siblingsCount) && (
                  <>
                      <PageButton number={1} handleChangePage={() => handleChangePage(1)} />
                      { page > (2 + siblingsCount) && (
                      <p>...</p>
                      )}
                  </>
              )}

              {previousPages.length > 0 && previousPages.map((page: any) => (
                  <PageButton key={page} number={page} handleChangePage={handleChangePage}/>
              ))}

              <PageButton number={page} isCurrent/>
      
              {nextPages.length > 0 && nextPages.map((page: any) => (
                  <PageButton key={page} number={page} handleChangePage={handleChangePage} />
              ))}

              {(page + siblingsCount) < (pageCount || 0) && (
                  <>
                      {( (page + 1 + siblingsCount) > siblingsCount && (page + siblingsCount < (pageCount || 0) - 1)) && (
                          <p>...</p>
                      )}
                      <PageButton number={pageCount} handleChangePage={handleChangePage} />
                  </>
              )}
              {!(page === pageCount) && 
              <div onClick={() => handleChangePage(page + 1)} style={{cursor: 'pointer'}}>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" className="bi bi-chevron-right" viewBox="0 0 16 16">
  <path fillRule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708z"/>
</svg>
                </div>}
      </>
  )
}

export default Pagination