import Link from 'next/link'
import Head from 'next/head'
import styles from '../styles/NotFound.module.scss'

export default function NotFound() {
  return (
    <>
      <Head>
        <title>Página Não Encontrada - Moov</title>
        <meta name="description" content="Página não encontrada" />
      </Head>
      <main className={styles.container}>
        <div className={styles.content}>
          <div className={styles.errorCode}>404</div>
          <h1 className={styles.title}>Ops! Página não encontrada</h1>
          <p className={styles.message}>
            A página que você está procurando não existe ou foi removida.
          </p>
          <Link href="/" className={styles.backButton}>
            Voltar para página inicial
          </Link>
        </div>
        <div className={styles.decoration}>
          <svg width="200" height="200" viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg">
            <circle cx="100" cy="100" r="90" stroke="#622167" strokeWidth="2" strokeOpacity="0.1"/>
            <circle cx="100" cy="100" r="70" stroke="#622167" strokeWidth="2" strokeOpacity="0.1"/>
            <circle cx="100" cy="100" r="50" stroke="#622167" strokeWidth="2" strokeOpacity="0.1"/>
            <path d="M100 20L100 40M100 160L100 180M20 100L40 100M160 100L180 100" stroke="#00BAB3" strokeWidth="2" strokeLinecap="round"/>
          </svg>
        </div>
      </main>
    </>
  )
}